/*
 * XXXX 
 *
 * Fecha 14/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet.presentacion.corredores;

import java.util.ArrayList;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.logic.P06BError;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.util.xml.P06BUtilXML;
import com.ejie.p06b.xml.P06BMediadorGenerateXML;


/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BCorredorComunicarDGSFPServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			if(request.getParameter("accion")==null){
				//Si vengo del men o doy a limpiar -> RESETEO TODOS LOS VALORES 
				//El parmetro fromMenu no lo tengo en cuenta en este caso (Si en el caso del alta por ej.)
				this.deleteAllTempFromSession(request);
				request.setAttribute("xmlToSend",this.obtenerXml());
			}else if(request.getParameter("accion").equals("enviar")){
				//Validamos el xml
				P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);
				request.setAttribute("xmlToSend",request.getParameter("xmlToSend"));
				boolean isValid=P06BUtilXML.validateStr((String)request.getAttribute("xmlToSend"),P06BParametros.get("xml.xsd.mediadores"));
				if(isValid){
					//Lo envio a la DGSFP (WEB SERVICE)
					//Cdigo aqu
					boolean enviado = false;
					int x;
					Random rnd = new Random();
				    x = (int)(rnd.nextDouble() * 10.0);
				    //Hay un 80% de posibilidades de que se enve ok
				    if(x<=7)  
				    	enviado = true;
					//Fin envio a la DGSFP
					if(enviado){
						forward (request, response, P06BPaginas.P06B_JSP_CORREDOR_COMUNICARDODGSFP);
						return;
					}else{
						//Indico que se ha producido un problema en el envo a la DGSFP
						ArrayList errors = new ArrayList();
						P06BError error = new P06BError();
						error.setNombreCampo(res.get("pantallas.literal.xmlAEnviar"));
						error.setCodigo(P06BErrores.P06B_ERROR_0013);
						errors.add(error);
						request.setAttribute("errors",errors);
					}
				}else{
					//Indico que no se cumple el xsd de forma vlida
					ArrayList errors = new ArrayList();
					P06BError error = new P06BError();
					error.setNombreCampo(res.get("pantallas.literal.xmlAEnviar"));
					error.setCodigo(P06BErrores.P06B_ERROR_0014);
					errors.add(error);
					request.setAttribute("errors",errors);
				}
			}
			forward (request, response, P06BPaginas.P06B_JSP_CORREDOR_COMUNICARDGSFP);
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
	//Obtenemos el xml a enviar
	private String obtenerXml() throws Exception {
		String xml = P06BMediadorGenerateXML.execute();
		return xml;
	}
}